let screenWidth = $(window).width();
$(document).ready(function() {
    $(".js-market-slider").owlCarousel({
        items: 3,
        loop: true,
        dots: false,
        nav: true,
        navElement: 'div',
        navText: ['<div class="play-btn"><div class="play-btn__wrap"><div class="play-btn__outer"><div class="play-btn__outer-circle"><img src="./img/style/icons/play_btn_outer.svg" alt=""></div></div><div class="play-btn__inner"><div class="play-btn__inner-circle"><img src="./img/style/icons/play_btn_inner.svg" alt=""></div></div><div class="play-btn__center"><img src="./img/style/icons/play_btn_center.svg" alt=""></div></div></div>','<div class="play-btn"><div class="play-btn__wrap"><div class="play-btn__outer"><div class="play-btn__outer-circle"><img src="./img/style/icons/play_btn_outer.svg" alt=""></div></div><div class="play-btn__inner"><div class="play-btn__inner-circle"><img src="./img/style/icons/play_btn_inner.svg" alt=""></div></div><div class="play-btn__center"><img src="./img/style/icons/play_btn_center.svg" alt=""></div></div></div>'],
        navClass: ['owl-arrow owl-prev', 'owl-arrow owl-next'],
        responsive: {
            0: {
                items: 1,
            },
            1024: {
                items: 2,
            },
            1440: {
                items: 3,
            },
        }
    });

    const mainVideo = document.getElementById("video");

    $(".js-play-btn").on("click", function(e) {
      $(this).toggleClass("active");
      if($(this).hasClass("active")) {
        mainVideo.pause();
      }else {
        mainVideo.play();
      }
    });

    $(".js-select").styler({});

    $(".js-menu-btn").on("click", function(e) {
        $(this).toggleClass("active");
        $("body").toggleClass("over");
        $(".js-menu").toggleClass("active");
    });

    if(screenWidth < 768) {
        $(".js-will-slide").addClass("owl-carousel");
        $(".js-will-slide").owlCarousel({
            items: 1,
            loop: true,
            dots: false,
            nav: true,
            navElement: 'div',
            navText: ['<div class="play-btn"><div class="play-btn__wrap"><div class="play-btn__outer"><div class="play-btn__outer-circle"><img src="./img/style/icons/play_btn_outer.svg" alt=""></div></div><div class="play-btn__inner"><div class="play-btn__inner-circle"><img src="./img/style/icons/play_btn_inner.svg" alt=""></div></div><div class="play-btn__center"><img src="./img/style/icons/play_btn_center.svg" alt=""></div></div></div>','<div class="play-btn"><div class="play-btn__wrap"><div class="play-btn__outer"><div class="play-btn__outer-circle"><img src="./img/style/icons/play_btn_outer.svg" alt=""></div></div><div class="play-btn__inner"><div class="play-btn__inner-circle"><img src="./img/style/icons/play_btn_inner.svg" alt=""></div></div><div class="play-btn__center"><img src="./img/style/icons/play_btn_center.svg" alt=""></div></div></div>'],
            navClass: ['owl-arrow owl-prev', 'owl-arrow owl-next'],
        });
    }

     AOS.init({
        once: true,
        offset: 520,
    });
});

let roadAnim;
let roads = document.querySelectorAll(".js-road-item");

roads.forEach(function(element){
    element.addEventListener("mouseenter", function( event ) {
        roadAnim = element.dataset.road;
        document.querySelector(".js-road-anim").classList.add(roadAnim);
    });
    element.addEventListener("mouseleave", function( event ) {
        // roadAnim = element.dataset.road;
        document.querySelector(".js-road-anim").classList.remove(roadAnim);
    });
});

let anchors = document.querySelectorAll(".js-anchor");
let anchor;

$(".js-anchor").click(function(e){
    e.preventDefault();
    $(".js-menu-btn").removeClass("active");
    $("body").removeClass("over");
    $(".js-menu").removeClass("active");
    var navTo = $(this).attr("data-target"),
        navElemTop = $(navTo).offset().top;
    $('body,html').animate({scrollTop: navElemTop}, 700);
});

function prealoader() {
    document.querySelector(".preloader").style.display = "none";
    document.querySelector(".body").classList.remove("over");
}


scene = new THREE.Scene();
camera = new THREE.PerspectiveCamera(40, 16 / 9, 0.10, 1000);
camera.position.z = 3;
camera.position.x = 17;
camera.position.y = 5;

renderer = new THREE.WebGLRenderer({alpha: true, antialias: true});
renderer.setClearColor(0x000000, 0);
renderer.setSize(1280, 720);

renderer.domElement.setAttribute("class", "webgl");
document.querySelector(".staking__model-item").appendChild(renderer.domElement);

const aLight = new THREE.AmbientLight(0X404040, 1.2);
scene.add(aLight);

const pLight = new THREE.PointLight(0Xffffff, 1.2);
pLight.position.set(2, 2.5, 0.2);
scene.add(pLight);

const helper = new THREE.PointLightHelper(pLight);
// scene.add(helper);

const canvas = document.querySelector("canvas.webgl");

let loader = new THREE.GLTFLoader();
let obj = null;

loader.load('./model/ship_4.glb', function(gltf) {
  obj = gltf;
  if(screenWidth >= 1440) {
    obj.scene.scale.set(1.1, 1.1, 1.1);
  }else if(screenWidth < 1440 && screenWidth >= 1024) {
    obj.scene.scale.set(0.9, 0.9, 0.9);
  }else if(screenWidth < 1024 && screenWidth >= 768) {
    obj.scene.scale.set(0.8, 0.8, 0.8);
  }else if(screenWidth < 768) {
    obj.scene.scale.set(0.8, 0.8, 0.8);
  }
  obj.scene.position.set(0, 0, 0); //
  obj.scene.rotation.y = 60;

  scene.add(obj.scene);
   // prealoader();
});

const controls = new THREE.OrbitControls(camera, canvas);
controls.enableDamping = true;
controls.enableZoom = false;

const minPan = new THREE.Vector3(0, 0, 0);
const maxPan = new THREE.Vector3(0, 0, 0);
const _v = new THREE.Vector3();

controls.addEventListener("change", function () {
  _v.copy(controls.target);
  controls.target.clamp(minPan, maxPan);
  _v.sub(controls.target);
  camera.position.sub(_v);
});

function animate() {
  requestAnimationFrame(animate);

   if(obj) {
     obj.scene.rotation.y += 0.00018;
  }
  renderer.render(scene, camera);
}
animate();
// renderer.render(scene, camera);


scene2 = new THREE.Scene();
camera2 = new THREE.PerspectiveCamera(40, 16 / 9, 0.10, 1000);
camera2.position.z = 8;
camera2.position.x = 16;
camera2.position.y = 6;

renderer2 = new THREE.WebGLRenderer({alpha: true, antialias: true});
renderer2.setClearColor(0x000000, 0);
renderer2.setSize(1280, 720);

renderer2.domElement.setAttribute("class", "webgl2");
document.querySelector(".main__model-item").appendChild(renderer2.domElement);

const aLight2 = new THREE.AmbientLight(0X404040, 1.2);
scene2.add(aLight2);

const pLight2 = new THREE.PointLight(0Xffffff, 1.2);
pLight2.position.set(0, 0, 10);
scene2.add(pLight2);

const helper2 = new THREE.PointLightHelper(pLight2);
// scene2.add(helper);

const canvas2 = document.querySelector("canvas.webgl2");

let loader2 = new THREE.GLTFLoader();
let obj2 = null;

loader2.load('./model/ship_2.glb', function(gltf) {
  obj2 = gltf;
  obj2.scene.position.set(-0.66, 0.4, 0.15); //
  if(screenWidth >= 1440) {
    obj2.scene.scale.set(0.10, 0.10, 0.10);
  }else if(screenWidth < 1440 && screenWidth >= 1024) {
    obj2.scene.scale.set(0.08, 0.08, 0.08);
  }else if(screenWidth < 1024 && screenWidth >= 768) {
    obj2.scene.scale.set(0.1, 0.1, 0.1);
  }else if(screenWidth < 768) {
    obj2.scene.scale.set(0.08, 0.08, 0.08);
  }

  scene2.add(obj2.scene);

});

const controls2 = new THREE.OrbitControls(camera2, canvas2);
controls2.enableDamping = true;
controls2.enableZoom = false;

const minPan2 = new THREE.Vector3(0, 0, 0);
const maxPan2 = new THREE.Vector3(0, 0, 0);
const _v2 = new THREE.Vector3();

controls2.addEventListener("change", function () {
  _v2.copy(controls2.target);
  controls2.target.clamp(minPan2, maxPan2);
  _v2.sub(controls2.target);
  camera2.position.sub(_v2);
});

function animate2() {
  requestAnimationFrame(animate2);

  //  if(obj2) {
  //    obj2.scene.rotation.y += 0.0000;
  // }
  renderer2.render(scene2, camera2);
  // renderer2.onAfterRender(alert("done"));
}
animate2();
// renderer.render(scene, camera);

